// SPDX-License-Identifier: MIT
pragma solidity ^0.8.24;

import "forge-std/Script.sol";
import {TicketRegistry} from "../src/TicketRegistry.sol";

/**
 * Deploys TicketRegistry with the broadcaster as initial owner.
 * The broadcaster should be your server/relayer wallet.
 */
contract Deploy is Script {
    function run() external {
        // Load private key from env via forge flag --private-key
        vm.startBroadcast();
        address initialOwner = msg.sender;
        TicketRegistry reg = new TicketRegistry(initialOwner);
        vm.stopBroadcast();

        console2.log("TicketRegistry deployed at:", address(reg));
        console2.log("Owner (initial):", initialOwner);
    }
}
